//---Figure 13.5
//---Variables & Constants
  LOW_LEVEL   = 65
  MAX_CHARGE  = 100
  BeaconX     = 600
  BeaconY     = 520
  Battery     = 0

//========================================
MainProgram:
  Gosub Information
  GoSub SetEnvironment
  While true
    gosub RoamAround
    gosub FindBeacon
    gosub FollowLine
    gosub ChargeBattery
  wend
End
//========================================
SetEnvironment:
  Trail=White
  LookingForDirt = False
  // Draw sofa and chairs
  SetColor White,Black
  rectangle 320,200,420,400,Black,Black
  xyText 335,300,"SOFA","Ariel",18,1
  circle 600,300,700,400,black,black
  xyText 610,335,"TABLE","Ariel",18,1
  rectangle 168,150,242,200,Black,Black
  xyText 175,165,"CHAIR","Ariel",14,1
  rectangle 168,405,242,450,Black,Black
  xyText 175,418,"CHAIR","Ariel",14,1
  rectangle 450,0,800,50,Black,Black
  rectangle 750,0,800,150,Black,Black
  xyText 600,20,"Kitchen","Ariel",18,1
  //--draw docking line
  SetColor Green,White
  LineWidth 2
  gotoxy BeaconX+100,BeaconY
  lineto BeaconX+50,BeaconY
  Lineto BeaconX,BeaconY-20
  Lineto BeaconX-50,BeaconY-20
  Line BeaconX-50,BeaconY+20,BeaconX,BeaconY+20
  Lineto BeaconX+50,BeaconY
  Arc BeaconX-70,BeaconY-20,BeaconX-30,BeaconY+20,DtoR(90),DtoR(180)
  //draw beacon
  circle BeaconX-30,BeaconY-10,BeaconX-10,BeaconY+10,red,red
  //draw charging station
  Rectangle BeaconX+105,BeaconY-12,BeaconX+180,BeaconY+12,blue,blue
  SetColor White,Blue
  xyText BeaconX+105,BeaconY-10,"CHARGER","Ariel",11
  //--Draw Battery meter
  SetColor Black,White
  LineWidth 3
  rectangle 80,0,260,40,black,white
  Rectangle 0,0,76,130,black
  gotoxy 1,123-LOW_LEVEL
  LineTo 75,123-LOW_LEVEL,3,Brown
  SetColor Black,White
  xyText 3,2,"BATTERY","Ariel",11
  //--Prepare to begin simulation
  WriteScr "StartScreen"
  GoSub PlaceRobot
  GoSub SimulateCharging
  pX =700  // X and Y coordinates of the Person
  pY =80   
  tendX=10 // tendency to move in X or Y direction
  tendY=10
  Gosub MovePerson  // creates person initially
return
//========================================
PlaceRobot:
  rLocate BeaconX+80,BeaconY,-90
  // designate the beacon and line colors as non-objects
  rInvisible White,Green,Red,LightBlue
  rIgnoreCharge False
Return
//========================================
RoamAround:
  while true
    SetColor Black
    xyString 100,10,"RANDOM ROAM    "
    GoSub BatteryMeter  // updates charge and meter
    Gosub MovePerson    // simulate person moving around room
    if Trail=Gray then Battery=LOW_LEVEL+10  // don't let battery run down if leaving a trail
    if Battery < LOW_LEVEL then return  // quit roaming if a charge is needed
    if random(10)<2        // set a random tendency for the persons movements
      tendX=random(20)-10
      tendY=random(20)-10
    endif
    // forward until an object or wall is encountered
    while not (rFeel( )&14) AND not (rBumper()&14))
       if rGPSx()>460 and rGPSy()>460  // keep robot out of charger area to keep graphics easy
         rForward -1
         break
       endif
       LineWidth 35   // vacuums by leaving either a white or gray trail (first invisible color)
       rPen Down
       rForward 1
       ReadMouse mx,my,mb  // let user interact with the two mouse buttons
       if mb=2             // right mouse button leaves a gray trail so vaccuumed area can be seen
         Trail=Gray
         rInvisible Trail,Green,Red,LightBlue  // trail is set to Gray
         rIgnoreCharge True  // keep battery charged
         LineWidth 1
         Rectangle 450,450,700,550,White,White // erase beacon and line since not needed now
       endif
       while mb=1          // Left mouse button starts dropping dirt randomly where the mouse is
         LineWidth 1
         ReadMouse mx,my,mb
         dirtX=mx-20+random(40)   // decide where to place the dirt
         dirtY=my-20+random(40)
         if dirtX<460 or dirtY<420 // but don't place it near the charger
           LineWidth 1
           circle dirtX-3,dirtY-3,dirtX+3,dirtY+3,LightBlue,LightBlue
         endif
         delay 50
       wend
       linewidth 35
    wend
    // object encountered, so turn some random direction - try different amounts of turns to improve coverage algorithm
    // much better coverage algorithms are discussed in our book   Robot Programmer's Bonanza
    D=random(100)
    for i=0 to random(70)+70
      if D>50
        rTurn 1
      else
        rTurn -1
      endif
    next 
    //before moving off again, use the 'camera' to check for dirt
    SetColor Black
    xyString 100,10,"TAKING PICTURE  "
    ScrToCb    // copies the screen to the clipboard, but RobotBASIC has commands to use a web cam
    BmpFindClr "",LightBlue,sn,,.1,.1,20  // looks for the dirt in a 20 by 20 grid in the clipboard image
    if sn>=0 and sn<=399  // sn holds the number of the grid with the most 'dirt'
      SetColor Black
      xyString 100,10,"SEE DIRT        "
      delay 500
      Row=sn/20  // find the Row and Column position of the dirt in the grid
      Col=sn#20
      dirtX=20+Col*40   // convert the Row and Column position to an X-Y screen coordinate
      dirtY=15+Row*30   // in real mode, this would have to be in feet or inches instead of pixels
      gosub GoToDirt    // Robot should find its way to the dirt and vaccuum that small area
    endif
    // continue with random roaming
  wend
return

//========================================
// charge is needed so MOVE TO THE BEACON while looking for a green line to follow
FindBeacon:                 
  SetColor Black
  xyString 100,10,"NEED CHARGE     "
  rInvisible Green,Green,Red,LightBlue      // can't use white or the floor would trigger the line sensors
  rPen UP   // don't vaccuum (don't leave a trail)
  SetColor Black,White
  cnt=0
  Repeat
    GoSub BatteryMeter
    cnt=cnt+1
    gosub FaceBeacon
    if cnt <20       // try 20 times, if it fails, then get unstuck with random movements (only needed in complex environments)
      gosub ForwardTillBlocked
      // decide to follow to the left or right
      if (cnt=1) and (rFeel()&8) then cnt=10
      if (cnt<10) or (random(20)<2) 
        TurnDir = -1
      else
        TurnDir = 1
      endif 
      GoSub GoAround   // go around for a RANDOM distance 
    else
      gosub UnStick
      cnt=0
    endif
  Until rGround(2)=Green // Line Found
Return

//========================================
FaceBeacon:
  while not rBeacon(Red)
    rTurn 1
  wend
  GoSub BatteryMeter
return

//========================================
ForwardTillBlocked:
  LineWidth 35
  while not (rFeel() & 14) AND not (rBumper() & 14)
    rForward 1
    if rSense() then break
  wend    
  GoSub BatteryMeter
return

//========================================
GoAround:          // follows edge of current object for a random distance
  LineWidth 35
  SetColor black
  xyString 100,10, "GO AROUND OBJECT "
  if rSense()and not LookingForDirt then return
  If TurnDir > 0 
     FN = 6
  Else
     FN = 12
  Endif
  for i=1 to 20 + random(250)
     While (rFeel()&FN) or (rBumper()&4)
       rTurn -TurnDir
     Wend
     rForward 1
     rTurn TurnDir
  Next
Return

//========================================
UnStick:       
  // these random movements will ALWAYS unstick the robot in COMPLEX environments
  // full explanation in Robot Programmer's Bonanza
  if random(100)<50 then rTurn 180
  for i=0 to 100+random(200)
     while not(rbumper()&14) 
        rForward 1
     wend 
     rTurn random(8)-3
  next
Return

//========================================
// Simple line follow to allow robot to properly orient itself to the charger
FollowLine:
  while rFeel()=0
    rForward 1
    while rSense() & 1
      rTurn 1
    wend
    while rSense() & 4
      rTurn -1
    wend
  wend
Return

//========================================
// rotate the robot and back into charger, then simulate charge
ChargeBattery:
  rTurn 180
  while not rBumper()
    rForward -1
  wend
  GoSub SimulateCharging
Return

//========================================
// shows charge on the simulated meter
SimulateCharging:
  LineWidth 2
  SetColor LightMagenta
  for i= Battery to MAX_CHARGE
   gotoxy 5,125-i
   lineto 70,125-i
   Delay 100
   gotoxy 1,123-LOW_LEVEL
   LineTo 75,123-LOW_LEVEL,3,Brown
  next
  rCharge MAX_CHARGE
  Battery = MAX_CHARGE
  rPen up
  for i=1 to 300
    if not(rBumper()&14) then rForward 1
  next
  rInvisible White,Green,Red,LightBlue              
Return

//========================================
// read the robot's charge level and display it on the simulated meter
BatteryMeter:
   if Trail=Gray then return
   // Show battery condition
   LineWidth 2
   Battery=rChargeLevel()
   SetColor White
   gotoxy 5,120-Battery
   lineto 70,120-Battery
   gotoxy 1,123-LOW_LEVEL
   LineTo 75,123-LOW_LEVEL,3,Brown
Return

//========================================
// randomly move the simulated person around in the kitchen area
MovePerson:
  if Trail!=White then return
  LineWidth 1
  oldpX = pX
  oldpY = pY
  pX = pX+random(10)-5+tendX
  pY = pY+random(10)-5+tendY
  if pX< 500 then pX=500
  if pX> 730 then pX=730
  if pY< 75 then pY=75
  if pY>290 then pY=290
  circle oldpX-10,oldpY-10,oldpX+10,oldpY+10, White,White
  circle pX-10,pY-10,pX+10,pY+10,DarkGray,DarkGray
Return

//=======================================
// determine the coordinates of a dirty area and move to it while avoiding objects
GoToDirt:
  cnt=0
  LookingForDirt=true
  DirtFound=false
  Repeat
    GoSub BatteryMeter
    LineWidth 35
    cnt=cnt+1
    gosub FaceDirt    // similar agorithm as facing the beacon, etc, to find the charger
    gosub ForwardToDirt
    // decide to follow left or right
    if (cnt=1) and (rFeel()&8) then cnt=10
    if (cnt<10) or (random(20)<2) 
      TurnDir = -1
    else
      TurnDir = 1
    endif 
    if rFeel() then GoSub GoAround
  Until DirtFound or cnt>20 // Line Found
  SetColor Black
  xyString 100,10,"CLEAN UP        "
  // now that we are at the dirty coordinates, vaccuum the area randomly by moving back and forth
  LineWidth 35
  rTurn -50
  for v2=1 to 15
    if not rBumper() then rForward -1
  next
  for v=1 to 8
    for v2=1 to 20+random(30)
      if not rBumper()then rForward 1
    next
    for v2=1 to 20+random(30)
      if not rBumper() then rForward -1
    next
    rturn 30
  next
  DirtFound=False
  LookingForDirt=false
Return

// ========================================
// use the GPS (or a Local Pos. System) to determine the robot's coordinates
// use trig to determine the angle to the dirt... then turn to that angle 
FaceDirt:
  LineWidth 35
  SetColor Black
  xyString 100,10,"FACE DIRT       "
  curX=rGPSx()
  curY=rGPSy()
  SetColor black\linewidth 2
  TotX=dirtX-curX
  TotY=curY-dirtY
  if TotX=0 then TotX=.0001  // prevent division by zero
  // now find the angle to the dirt
  dirtAngle=rTOd(atan(ABS (1.0*TotY/TotX)))
  dirtAngle=round (90-dirtAngle)
  if TotX>0 and TotY>0
  endif
  if TotX>0 and TotY<0
    dirtAngle+=2*(90-dirtAngle)
  endif
  if TotX<0 and TotY<0
    dirtAngle+=180
  endif
  if TotX<0 and TotY>0
    dirtAngle=-dirtAngle
  endif  
  while dirtAngle<0 
    dirtAngle+=360
  wend
  while dirtAngle>359
    dirtAngle-=360
  wend
  // now that the angle has been found, turn to that angle
  while rCompass()<>dirtAngle
    rTurn 1
  wend
Return

//============================================
// move to dirt using the same algorithm as moving to the beacon
// avoid objects by going around them
// stop only after robot is close to the dirt coordinates
ForwardToDirt:
  LineWidth 35
  SetColor Black
  xyString 100,10,"FORWARD         "
  while not (rFeel() & 14) AND not (rBumper() & 14)
    rForward 1
    remaining = sqrt((rGPSx()-dirtX)*(rGPSx()-dirtX))+((rGPSy()-dirtY)*(rGPSy()-dirtY))
    if remaining<10
      DirtFound=true
      break
    endif
       ReadMouse mx,my,mb
       if mb=2 
         Trail=Gray
         rInvisible Trail,Green,Red,LightBlue
       endif
       while mb=1
         LineWidth 1
         ReadMouse mx,my,mb
         dirtX=mx-20+random(40)
         dirtY=my-20+random(40)
         if dirtX<460 or dirtY<460
           vc=PixelClr(dirtX,dirtY)
           LineWidth 1
           circle dirtX-3,dirtY-3,dirtX+3,dirtY+3,LightBlue,LightBlue
         endif
         delay 50
       wend
  wend    
  GoSub BatteryMeter
return

//============================================================================
Information:
  Print "                                Intelligent Vaccuum System  "
  print 
  Print "  The Robot Vaccuum will normally roam randomly around the room picking up dirt."
  print "  As it moves, it avoids objects and makes random turns when objects or walls are"
  print "  encountered. A person will move around in the Kitchen. The robot will avoid the"
  print "  person just as it does other objects."
  print 
  print "  Every time it hits an object it takes a picture of the room from a ceiling camera."
  print "  If popcorn or any type of dirt is seen, the robot moves to the area of MOST dirt and"
  print "  performs a cleanup operation.  It will find its way to the dirt even if there are"
  print "  objects in the way."
  print
  print "  If the battery charge level is low, the robot will find its way to the charger and"
  print "  resume what it was doing after the charge is complete.  It locates the charger by"
  print "  looking for a beacon, and when a line on the floor is found, it will follow the line"
  print "  to the charger, then turn around and back into the charger to make the proper"
  print "  electrical connection. It turns the vaccuum off when near the charger."
  print
  print "  You can place 'dirt' anywhere by holding down the LEFT mouse button and moving the"
  print "  mouse.  DO NOT PLACE dirt on the furniture or near the charger (where it does not"
  print "  clean).  If you do, the robot will see the dirt, but will not be able to pick it up."
  print "  This will really confuse the robot, because it will keep trying."
  print
  print "  If you would like to see how well the random action cleans a room, you can press the"
  print "  the RIGHT mouse button to cause the robot to leave a trail where it is cleaning."
  print "  You should let the robot clean for an extended period of time, and then you can see"
  print "  how much of the floor has been cleaned.  During that time, the human will not move, "
  print "  and the robot will not need a charge. Our book ROBOT PROGRAMMER'S BONANZA develops"
  print "  better algorithms for covering the entire room. See RobotBASIC.com for information."    
  print
  print "  This is just a simple example of how algorithms can be tested with RobotBASIC."
  addbutton  " Click to Continue ", 350,550
  repeat 
     GetButton ButName
  until ButName=" Click to Continue "
  RemoveButton " Click to Continue "
  clearscr
Return
